/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.util;

import bettercombat.mod.capability.CapabilityOffhandCooldown;
import bettercombat.mod.event.RLCombatCriticalHitEvent;
import bettercombat.mod.event.RLCombatModifyDamageEvent;
import bettercombat.mod.event.RLCombatSweepEvent;
import bettercombat.mod.handler.EventHandlers;
import bettercombat.mod.util.ConfigurationHandler;
import bettercombat.mod.util.QualityToolsHandler;
import bettercombat.mod.util.ReskillableHandler;
import bettercombat.mod.util.Sounds;
import bettercombat.mod.util.SpartanWeaponryHandler;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import meldexun.reachfix.util.ReachFixUtil;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentSweepingEdge;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class Helpers {
    private Helpers() {
    }

    public static <T> void execNullable(@Nullable T obj, Consumer<T> onNonNull) {
        if (obj != null) {
            onNonNull.accept(obj);
        }
    }

    public static <T, R> R execNullable(@Nullable T obj, Function<T, R> onNonNull, R orElse) {
        if (obj != null) {
            return onNonNull.apply(obj);
        }
        return orElse;
    }

    public static void clearOldModifiers(EntityLivingBase entity, ItemStack stack) {
        if (!stack.func_190926_b() && entity != null) {
            HashMultimap modifiersToRemove = HashMultimap.create();
            for (Map.Entry modifier : stack.func_111283_C(EntityEquipmentSlot.MAINHAND).entries()) {
                if (!((String)modifier.getKey()).contains("attackDamage") && !((String)modifier.getKey()).contains("attackSpeed") && !((String)modifier.getKey()).contains("reachDistance")) continue;
                modifiersToRemove.put(modifier.getKey(), modifier.getValue());
            }
            if (Loader.isModLoaded((String)"qualitytools")) {
                QualityToolsHandler.clearOldModifiersQualityTools(entity, stack, (Multimap<String, AttributeModifier>)modifiersToRemove);
            }
            if (!modifiersToRemove.isEmpty()) {
                entity.func_110140_aT().func_111148_a((Multimap)modifiersToRemove);
            }
        }
    }

    public static void addNewModifiers(EntityLivingBase entity, ItemStack stack) {
        if (!stack.func_190926_b() && entity != null) {
            for (Map.Entry modifier : stack.func_111283_C(EntityEquipmentSlot.MAINHAND).entries()) {
                IAttributeInstance entityAttribute;
                if (((String)modifier.getKey()).contains("attackDamage")) {
                    entityAttribute = entity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e);
                    if (entityAttribute.func_180374_a((AttributeModifier)modifier.getValue())) continue;
                    entityAttribute.func_111121_a((AttributeModifier)modifier.getValue());
                    continue;
                }
                if (((String)modifier.getKey()).contains("attackSpeed")) {
                    entityAttribute = entity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f);
                    if (entityAttribute.func_180374_a((AttributeModifier)modifier.getValue())) continue;
                    entityAttribute.func_111121_a((AttributeModifier)modifier.getValue());
                    continue;
                }
                if (!((String)modifier.getKey()).contains("reachDistance") || (entityAttribute = entity.func_110140_aT().func_111151_a(EntityPlayer.REACH_DISTANCE)).func_180374_a((AttributeModifier)modifier.getValue())) continue;
                entityAttribute.func_111121_a((AttributeModifier)modifier.getValue());
            }
            if (Loader.isModLoaded((String)"qualitytools")) {
                QualityToolsHandler.addNewModifiersQualityTools(entity, stack);
            }
        }
    }

    public static float getOffhandDamage(EntityPlayer player) {
        float attack = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        return attack * (ConfigurationHandler.weakerOffhand ? ConfigurationHandler.offHandEfficiency : 1.0f);
    }

    public static int getOffhandCooldown(EntityPlayer player) {
        float speed = (float)player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111126_e();
        return (int)(1.0f / speed * 20.0f + 0.5f);
    }

    public static void attackTargetEntityItem(EntityPlayer player, Entity targetEntity, boolean offhand, double motionX, double motionY, double motionZ) {
        ItemStack weapon;
        ItemStack itemStack = weapon = offhand ? player.func_184592_cb() : player.func_184614_ca();
        if (MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent(player, targetEntity))) {
            return;
        }
        if (!weapon.func_190926_b() && weapon.func_77973_b().onLeftClickEntity(weapon, player, targetEntity)) {
            return;
        }
        if (Loader.isModLoaded((String)"reskillable") && ReskillableHandler.shouldLockAttack(player, weapon)) {
            return;
        }
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)player)) {
            double reach;
            float damage;
            int cooldown = 0;
            if (offhand) {
                Helpers.clearOldModifiers((EntityLivingBase)player, player.func_184614_ca());
                Helpers.addNewModifiers((EntityLivingBase)player, player.func_184592_cb());
                damage = Helpers.getOffhandDamage(player);
                cooldown = Helpers.getOffhandCooldown(player);
                reach = ReachFixUtil.getEntityReach((EntityPlayer)player, (EnumHand)EnumHand.OFF_HAND);
                Helpers.clearOldModifiers((EntityLivingBase)player, player.func_184592_cb());
                Helpers.addNewModifiers((EntityLivingBase)player, player.func_184614_ca());
            } else {
                damage = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                reach = ReachFixUtil.getEntityReach((EntityPlayer)player, (EnumHand)EnumHand.MAIN_HAND);
            }
            float cMod = targetEntity instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)weapon, (EnumCreatureAttribute)((EntityLivingBase)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)weapon, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
            float cooledStr = offhand ? (cooldown > 0 ? 1.0f - (float)Helpers.execNullable(player.getCapability(EventHandlers.TUTO_CAP, null), CapabilityOffhandCooldown::getOffhandCooldown, 0).intValue() / (float)cooldown : 1.0f) : player.func_184825_o(0.5f);
            RLCombatModifyDamageEvent.Pre modifyResultPre = new RLCombatModifyDamageEvent.Pre(player, targetEntity, offhand, weapon, damage, cooledStr, motionX, motionY, motionZ);
            MinecraftForge.EVENT_BUS.post((Event)modifyResultPre);
            damage += modifyResultPre.getDamageModifier();
            damage *= 0.2f + cooledStr * cooledStr * 0.8f;
            cMod *= cooledStr;
            if (offhand) {
                CapabilityOffhandCooldown coh = (CapabilityOffhandCooldown)player.getCapability(EventHandlers.TUTO_CAP, null);
                if (coh != null) {
                    coh.setOffhandCooldown(cooldown);
                    coh.setOffhandBeginningCooldown(cooldown);
                    if (!player.field_70170_p.field_72995_K) {
                        coh.sync();
                    }
                }
            } else {
                player.func_184821_cY();
            }
            if (damage > 0.0f || cMod > 0.0f) {
                boolean attacked;
                boolean isCrit;
                boolean isStrong = cooledStr > 0.9f;
                boolean knockback = false;
                int knockbackMod = EnchantmentHelper.func_77501_a((EntityLivingBase)player);
                int fireAspect = EnchantmentHelper.func_90036_a((EntityLivingBase)player);
                if (player.func_70051_ag() && isStrong) {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187721_dT, player.func_184176_by(), 1.0f, 1.0f);
                    ++knockbackMod;
                    knockback = true;
                }
                if (ConfigurationHandler.randomCrits) {
                    boolean bl = isCrit = player.func_70681_au().nextFloat() < ConfigurationHandler.critChance && !player.func_70051_ag() && (!ConfigurationHandler.requireEnergyToRandomCrit || isStrong);
                    if (!isCrit) {
                        isCrit = (!ConfigurationHandler.requireEnergyToJumpCrit || isStrong) && player.func_70032_d(targetEntity) < ConfigurationHandler.distanceToJumpCrit && player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(MobEffects.field_76440_q) && !player.func_184218_aH() && targetEntity instanceof EntityLivingBase && !player.func_70051_ag();
                    }
                } else {
                    isCrit = isStrong && player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(MobEffects.field_76440_q) && !player.func_184218_aH() && targetEntity instanceof EntityLivingBase && !player.func_70051_ag();
                }
                RLCombatCriticalHitEvent hitResult = new RLCombatCriticalHitEvent(player, targetEntity, isCrit ? 1.5f : 1.0f, isCrit, offhand);
                MinecraftForge.EVENT_BUS.post((Event)hitResult);
                if (!(hitResult.getResult() == Event.Result.ALLOW || isCrit && hitResult.getResult() == Event.Result.DEFAULT)) {
                    hitResult = null;
                }
                boolean bl = isCrit = hitResult != null;
                if (isCrit) {
                    damage *= hitResult.getDamageModifier();
                }
                RLCombatModifyDamageEvent.Post modifyResultPost = new RLCombatModifyDamageEvent.Post(player, targetEntity, offhand, weapon, damage += cMod, cooledStr, motionX, motionY, motionZ, DamageSource.func_76365_a((EntityPlayer)player));
                MinecraftForge.EVENT_BUS.post((Event)modifyResultPost);
                damage += modifyResultPost.getDamageModifier();
                DamageSource dmgSource = modifyResultPost.getDamageSource();
                boolean doSweepingIgnoreSword = false;
                boolean doSweeping = false;
                double tgtDistDelta = player.field_70140_Q - player.field_70141_P;
                if (isStrong && !isCrit && !knockback && player.field_70122_E && tgtDistDelta < (double)player.func_70689_ay()) {
                    doSweepingIgnoreSword = true;
                    if (weapon.func_77973_b() instanceof ItemSword) {
                        doSweeping = true;
                    }
                }
                float tgtHealth = 0.0f;
                boolean burnInflicted = false;
                if (targetEntity instanceof EntityLivingBase) {
                    tgtHealth = ((EntityLivingBase)targetEntity).func_110143_aJ();
                    if (fireAspect > 0 && !targetEntity.func_70027_ad()) {
                        targetEntity.func_70015_d(1);
                        burnInflicted = true;
                    }
                }
                double tgtMotionX = targetEntity.field_70159_w;
                double tgtMotionY = targetEntity.field_70181_x;
                double tgtMotionZ = targetEntity.field_70179_y;
                if (offhand) {
                    Entity targetEntCap = targetEntity;
                    if (targetEntCap instanceof MultiPartEntityPart) {
                        targetEntCap = (Entity)((MultiPartEntityPart)targetEntCap).field_70259_a;
                    }
                    float attackDmgFinal = damage;
                    attacked = Helpers.execNullable(targetEntCap.getCapability(EventHandlers.SECONDHURTTIMER_CAP, null), sht -> sht.attackEntityFromOffhand(targetEntity, dmgSource, attackDmgFinal), false);
                } else {
                    attacked = targetEntity.func_70097_a(dmgSource, damage);
                }
                if (attacked) {
                    IEntityMultiPart ientitymultipart;
                    if (knockbackMod > 0) {
                        if (targetEntity instanceof EntityLivingBase) {
                            ((EntityLivingBase)targetEntity).func_70653_a((Entity)player, (float)knockbackMod * 0.5f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)knockbackMod * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)knockbackMod * 0.5f));
                        }
                        player.field_70159_w *= 0.6;
                        player.field_70179_y *= 0.6;
                        if (!ConfigurationHandler.moreSprint) {
                            player.func_70031_b(false);
                        }
                    }
                    RLCombatSweepEvent sweepResult = new RLCombatSweepEvent(player, targetEntity, damage, offhand, weapon, doSweepingIgnoreSword, doSweeping, EnchantmentSweepingEdge.func_191526_e((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_191530_r, (ItemStack)player.func_184586_b(offhand ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND))), targetEntity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0), DamageSource.func_76365_a((EntityPlayer)player));
                    MinecraftForge.EVENT_BUS.post((Event)sweepResult);
                    doSweeping = sweepResult.getDoSweep();
                    if (doSweeping) {
                        float sweepingDamage = 1.0f + sweepResult.getSweepModifier() * damage;
                        AxisAlignedBB sweepingAABB = sweepResult.getSweepingAABB();
                        DamageSource sweepingDamageSource = sweepResult.getSweepingDamageSource();
                        for (EntityLivingBase living : player.field_70170_p.func_72872_a(EntityLivingBase.class, sweepingAABB)) {
                            if (living == player || living == targetEntity || player.func_184191_r((Entity)living) || !(player.func_70068_e((Entity)living) < reach * reach)) continue;
                            living.func_70653_a((Entity)player, 0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                            if (offhand) {
                                Helpers.execNullable(living.getCapability(EventHandlers.SECONDHURTTIMER_CAP, null), sht -> sht.attackEntityFromOffhand((Entity)living, sweepingDamageSource, sweepingDamage));
                                continue;
                            }
                            living.func_70097_a(sweepingDamageSource, sweepingDamage);
                        }
                        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
                        player.func_184810_cG();
                    }
                    if (targetEntity instanceof EntityPlayerMP && targetEntity.field_70133_I) {
                        ((EntityPlayerMP)targetEntity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.field_70159_w = tgtMotionX;
                        targetEntity.field_70181_x = tgtMotionY;
                        targetEntity.field_70179_y = tgtMotionZ;
                    }
                    if (isCrit) {
                        if (offhand) {
                            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187718_dS, player.func_184176_by(), 1.0f, 1.0f);
                        }
                        player.func_71009_b(targetEntity);
                    }
                    boolean playSound = true;
                    if (!weapon.func_190926_b()) {
                        if (weapon.func_77973_b() instanceof ItemSpade) {
                            playSound = false;
                        }
                        if (playSound) {
                            if (!(!ConfigurationHandler.hitSound || ConfigurationHandler.critSound && isCrit)) {
                                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, Sounds.SWORD_SLASH, player.func_184176_by(), 1.0f, 1.0f);
                            }
                            if (ConfigurationHandler.critSound && isCrit) {
                                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, Sounds.CRITICAL_STRIKE, player.func_184176_by(), 1.0f, 1.0f);
                            }
                        }
                    }
                    if (!isCrit && !doSweeping) {
                        if (isStrong) {
                            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187727_dV, player.func_184176_by(), 1.0f, 1.0f);
                        } else {
                            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187733_dX, player.func_184176_by(), 1.0f, 1.0f);
                        }
                    }
                    if (cMod > 0.0f) {
                        player.func_71047_c(targetEntity);
                    }
                    if (!player.field_70170_p.field_72995_K && targetEntity instanceof EntityPlayer) {
                        ItemStack activeItem;
                        EntityPlayer entityplayer = (EntityPlayer)targetEntity;
                        ItemStack itemStack2 = activeItem = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                        if (weapon.func_77973_b() instanceof ItemAxe && activeItem.func_77973_b() instanceof ItemShield) {
                            float efficiency = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)player) * 0.05f;
                            if (knockback) {
                                efficiency += 0.75f;
                            }
                            if (player.func_70681_au().nextFloat() < efficiency) {
                                entityplayer.func_184811_cZ().func_185145_a(activeItem.func_77973_b(), 100);
                                player.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                            }
                        }
                    }
                    player.func_130011_c(targetEntity);
                    if (targetEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)player);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)player, (Entity)targetEntity);
                    Entity entity = targetEntity;
                    if (targetEntity instanceof MultiPartEntityPart && (ientitymultipart = ((MultiPartEntityPart)targetEntity).field_70259_a) instanceof EntityLivingBase) {
                        entity = (EntityLivingBase)ientitymultipart;
                    }
                    if (!weapon.func_190926_b() && entity instanceof EntityLivingBase) {
                        ItemStack beforeHitCopy = weapon.func_77946_l();
                        weapon.func_77961_a((EntityLivingBase)entity, player);
                        if (weapon.func_190926_b()) {
                            player.func_184611_a(offhand ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)beforeHitCopy, (EnumHand)(offhand ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND));
                        }
                    }
                    if (targetEntity instanceof EntityLivingBase) {
                        float healthDelta = tgtHealth - ((EntityLivingBase)targetEntity).func_110143_aJ();
                        player.func_71064_a(StatList.field_188111_y, Math.round(healthDelta * 10.0f));
                        if (fireAspect > 0) {
                            targetEntity.func_70015_d(fireAspect * 4);
                        }
                        if (player.field_70170_p instanceof WorldServer && healthDelta > 2.0f) {
                            int k = (int)((double)healthDelta * 0.5);
                            ((WorldServer)player.field_70170_p).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, targetEntity.field_70165_t, targetEntity.field_70163_u + (double)(targetEntity.field_70131_O * 0.5f), targetEntity.field_70161_v, k, 0.1, 0.0, 0.1, 0.2, new int[0]);
                        }
                    }
                    player.func_71020_j(0.3f);
                } else {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187724_dU, player.func_184176_by(), 1.0f, 1.0f);
                    if (burnInflicted) {
                        targetEntity.func_70066_B();
                    }
                }
                if (Loader.isModLoaded((String)"spartanweaponry")) {
                    SpartanWeaponryHandler.handleSpartanQuickStrike(weapon, targetEntity);
                }
            }
        }
    }

    @Nonnull
    public static <T> T getNull() {
        return null;
    }
}

